function [ tout,yout ] = Diffusion( S1,S2,tstep,tfinal )
%Compute the Dirichlet diffusion given Stiffness matrices
%   The Galerkin approximation says 0 = S1*c' + S2*c with the implied
%   restriction due to you may only test up to N_{n-1} and c_{n} = 1. Thus,
%   we do not include the bottom rows of S1 and S2 and c_{n} is fixed at 1.
%   tout and yout are the time points and corresponding nodal values. Note
%   the time values of output are ROWS of yout, eg yout(:,k)

n = size(S1,1);

%Because we have a constant right endpoint dirichlet condition, we only test by the
%first n-1 basis splines that vanish at that end as cn=1 Thus the system is
%0 = [S1(1,:);...;S1(n-1,:)][c1' ... c(n-1)' 0]' + [S2(1,:);...;S2(n-1,:)][c1 ... c(n-1) 1]'
%This may be simplified to a system for n-1 coefficients like so
%0 = S1(1:n-1,1:n-1)[c1' ... c(n-1)']' + S2(1:n-1,1:n-1)[c1 ... c(n-1)] + S2(1:n-1,n)

A = S1(1:n-1,1:n-1);
B = S2(1:n-1,1:n-1);
f = S2(1:n-1,n);

%0 = Ac' + Bc + f
DE = @(t,y) A^(-1)*(-B*y-f); %ODE equation for input in ODE45
y0 = zeros(n-1,1); %Vector of initial data
[tout,yout] = ode45(DE,0:tstep:tfinal,y0); 

%Augment yout to include now the constant cn = 1 term.
yout = [yout 1+zeros(size(yout,1),1)];


end

